#!/bin/bash

/home/andrew/splash.sh &
SPLASHPID=$(echo $!)

echo "Turning off Autosuspend on USB devices"
echo -1 > /sys/module/usbcore/parameters/autosuspend

echo "Turning Off CPU Auto Power Control"
echo 0 > /sys/devices/system/cpu/cpuquiet/tegra_cpuquiet/enable

echo "Turning On all CPU's"
echo 1 > /sys/devices/system/cpu/cpu1/online
echo 1 > /sys/devices/system/cpu/cpu2/online
echo 1 > /sys/devices/system/cpu/cpu3/online
echo 1 > /sys/devices/system/cpu/cpu4/online
echo 1 > /sys/devices/system/cpu/cpu5/online

echo "Enabling Performance Optimization"
echo performance > /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor
echo performance > /sys/devices/system/cpu/cpu1/cpufreq/scaling_governor
echo performance > /sys/devices/system/cpu/cpu2/cpufreq/scaling_governor

sudo jetson_clocks

echo "CPU's Active"
cat /sys/devices/system/cpu/online

echo "CPU 0 Frequency"
cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq

echo "CPU 1 Frequency"
cat /sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq

echo "CPU 2 Frequency"
cat /sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq

echo "CPU 3 Frequency"
cat /sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq

echo "CPU 4 Frequency"
cat /sys/devices/system/cpu/cpu4/cpufreq/scaling_cur_freq

echo "CPU 5 Frequency"
cat /sys/devices/system/cpu/cpu5/cpufreq/scaling_cur_freq

#sudo mount /dev/sda1 /media/andrew/datapartition/

#I2S setup
sudo devmem2 0x02434000 h 0x454
sudo devmem2 0x02434008 h 0x404
sudo devmem2 0x02434010 h 0x444
sudo devmem2 0x02434018 h 0x444

# sudo devmem2  0x0c302020 h 0x400
# sudo devmem2  0x0c302018 h 0x450

cd /home/andrew/Desktop
sudo rmmod imx219
sudo systemctl stop nvargus-daemon
sudo systemctl stop serial-getty@ttyS0.service
sudo systemctl stop serial-getty@ttyS2.service

sudo echo pll_p_out0 >  /sys/kernel/debug/bpmp/debug/clk/uartc/parent 
sudo echo 1843200  >  /sys/kernel/debug/bpmp/debug/clk/uartc/rate 

sudo insmod imx219.ko
#sudo rmmod snd-soc-tlv320adc310x
sudo insmod snd-soc-tlv320adc310x.ko
sudo insmod /home/andrew/Desktop/pl2303.ko
sleep .2

amixer -c  tegrasndt186ref sset "I2S2 Mux" ADMAIF1 
amixer -c  tegrasndt186ref sset "ADMAIF1 Mux" I2S2 
#pactl set-default-sink alsa_output.platform-3510000.hda.hdmi-stereo-extra1

 sudo gpasswd --add ${USER} dialout
# sudo gpasswd --add ${USER} tty

echo 306 > /sys/class/gpio/export  #Buzzer
echo out  > /sys/class/gpio/gpio306/direction

echo 276 > /sys/class/gpio/export  #Rec LED
echo out  > /sys/class/gpio/gpio276/direction
echo 1 > /sys/class/gpio/gpio276/value

echo 290 > /sys/class/gpio/export  #485 RDE (1)
echo out  > /sys/class/gpio/gpio290/direction 

echo 291 > /sys/class/gpio/export  #485 RDE (2)
echo out  > /sys/class/gpio/gpio291/direction 

echo 376 > /sys/class/gpio/export  #Record
echo in  > /sys/class/gpio/gpio376/direction

echo 377 > /sys/class/gpio/export  #stop/up
echo in  > /sys/class/gpio/gpio377/direction

echo 378 > /sys/class/gpio/export  #photo
echo in  > /sys/class/gpio/gpio378/direction

echo 379 > /sys/class/gpio/export  #pause/down
echo in  > /sys/class/gpio/gpio379/direction

echo 483 > /sys/class/gpio/export  #Move/Left
echo in  > /sys/class/gpio/gpio483/direction

echo 273 > /sys/class/gpio/export  #PIP/Esc
echo in  > /sys/class/gpio/gpio273/direction

echo 274 > /sys/class/gpio/export  #Menu/Sel
echo in  > /sys/class/gpio/gpio274/direction

echo 275 > /sys/class/gpio/export  #Swap/Right
echo in  > /sys/class/gpio/gpio275/direction

echo 264 > /sys/class/gpio/export  #Front C HPD
echo in  > /sys/class/gpio/gpio264/direction
sudo devmem2 0x0c301080 h 0x58 #gpio 264 pull-up enable

echo 269 > /sys/class/gpio/export  #SATA mux select 
echo out  > /sys/class/gpio/gpio269/direction
echo 1  > /sys/class/gpio/gpio269/value # set to PCIe 

echo 392 > /sys/class/gpio/export  #Video 4 reset 
echo out  > /sys/class/gpio/gpio392/direction
echo 1  > /sys/class/gpio/gpio392/value  

echo 393 > /sys/class/gpio/export  #Video 1 reset
echo out  > /sys/class/gpio/gpio393/direction
echo 1  > /sys/class/gpio/gpio393/value 

echo 394 > /sys/class/gpio/export  #Video 3 reset
echo out  > /sys/class/gpio/gpio394/direction
echo 1  > /sys/class/gpio/gpio394/value 

echo 395 > /sys/class/gpio/export  #Video 2 reset
echo out  > /sys/class/gpio/gpio395/direction
echo 1  > /sys/class/gpio/gpio395/value 

echo 410 > /sys/class/gpio/export #BT enable
echo out > /sys/class/gpio/gpio410/direction 
echo 1 > /sys/class/gpio/gpio410/value

echo 408 > /sys/class/gpio/export #wifi enable
echo out > /sys/class/gpio/gpio408/direction 
echo 1 > /sys/class/gpio/gpio408/value


#while ![xhost >& /dev/null] ; do 
#:
#echo "Display does not exists"
#done
#sudo xinit

sudo ln -sf /home/andrew/Desktop/1.16.3/build/gst/libgstreamer-1.0.so.0.1603.0 /usr/lib/aarch64-linux-gnu/libgstreamer-1.0.so.0
sudo ln -sf /home/andrew/Desktop/1.16.3/build/gst/libgstreamer-1.0.so.0.1603.0 /usr/lib/aarch64-linux-gnu/libgstreamer-1.0.so


cd /home/andrew/Desktop/ShareContext

if test -f overlay2; then #if an update has been added 
    if test -f overlayBackup; then #if there is already a backup
	rm overlayBackup
    fi
    mv overlay overlayBackup
    mv overlay2 overlay
    sudo chmod 777 overlay
    rm save.dat
    rm save2.dat
    echo Success > UPDATE_SUCCESS
fi 

if [ ! -f overlay ]; then #if an update broke the old one
    cp overlayBackup overlay
    sudo chmod 777 overlay
fi 

sleep 5


DRIVES=$(ls /media/andrew/  ) # remove all unmounted dead folders

for t in $DRIVES ; do  # for entries in DRIVE
	MOUTPOINT=$(df -h /media/andrew/$t | tail -n 1 | awk -F " " '{print $1}' | grep /dev/root)
	if test ${#MOUTPOINT} != '0' ; then 
	    sudo rm -r /media/andrew/$t
	fi
done

DRIVES=$(ls /media/andrew/  ) # remove all mounted dead folders

for t in $DRIVES ; do  # for entries in DRIVE
	MOUTPOINT=$(lsblk | grep $(df -h /media/andrew/$t | tail -n 1 | awk -F " " '{print $1}' | awk -F / '{print $3}'))
	if test ${#MOUTPOINT} == '0' ; then 
	    #echo need to remove $t
	    sudo umount /media/andrew/$t
	    sudo rm -r /media/andrew/$t
	fi
done

DRIVES=$(lsblk | grep sd | cut -c 7-11 | grep sd) # find all atatched drives and copy into DRIVE array

for t in $DRIVES ; do  # for entries in DRIVE
     TEMP=$(readlink -f /sys/class/block/$t/device | grep usb) #if DRIVE is not on USB,
     if [ ${#TEMP} = "0" ] ; then   # then mount it as hard drive
	echo  mounting "$t" as internal drive
	mkdir /media/andrew/datapartition/
	sudo umount /media/andrew/$(lsblk | grep $t | awk -F / '{print $4}')
	sudo mount -t exfat /dev/$t /media/andrew/datapartition/
	sudo mount -o remount,rw /media/andrew/datapartition/
        mkdir /media/andrew/datapartition/videoout
     else 
	echo not mounting "$t" as internal drive length ${#TEMP}
     fi 
done

sudo kill -9 $SPLASHPID

COUNTER=20
while test $COUNTER -ge 0 ; do
   #sudo startx  ./overlay
   HOME=/home/andrew sudo STARTVERSION=1.0.3 CONFIGURATION=RELEASE startx ./overlay --screen 0 1920x1080 --screen 1 1920x1080
	let "COUNTER=COUNTER-1"

done


UPTIME=$(uptime -p | awk '{print $2}') 

if test $UPTIME -le 5 ; then  #restore backup if overlay is not running (20 failed launches in 5 minutes)
    cd /home/andrew/Desktop/ShareContext
    if test -f overlayBackup; then #if there is already a backup
	rm overlay
	cp overlayBackup overlay
	sudo chmod 777 overlay
	echo failed > UPDATE_FAILED
	reboot
    fi
fi


 

